<?php
    $class= 'w-full h-24 text-sm px-3 py-2.5 mt-1 rounded-lg border border-light-gray text-black placeholder-light-gray bg-white disabled:bg-gray-200 focus:outline-none focus:ring-transparent focus:border-purple';

    if ($attributes->has('override')) {
        $class = $attributes->get('override');
    } elseif ($attributes->get('class')) {
        $class .= ' ' . $attributes->get('class');
    }
?>
<textarea
    name="<?php echo e($name); ?>"
    id="<?php echo e($id); ?>"
    class="<?php echo e($class); ?>"
    rows="<?php echo e($rows); ?>"
    placeholder="<?php echo e($placeholder); ?>"
    <?php if($disabled): ?>
    disabled="disabled"
    <?php endif; ?>
    <?php if($required): ?>
    required="required"
    <?php endif; ?>
    <?php if($readonly): ?>
    readonly="readonly"
    <?php endif; ?>
    <?php echo e($attributes->except(['rows', 'placeholder', 'disabled', 'required', 'readonly'])); ?>

><?php echo $value; ?></textarea>
<?php /**PATH /home1/pmnvir/public_html/acc/resources/views/components/form/input/textarea.blade.php ENDPATH**/ ?>